/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.StorableInput;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoIOException;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.action.ToolSelectionAction;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.ToolButtonListener;
import DE.siemens.ad.pdraw.standard.ToolJButton;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class DrawApplication
implements DrawingEditor,
ToolButtonListener {
    protected JToolBar fStandardToolBar = null;
    protected JToolBar fToolPalette = null;
    private Drawing fDrawing;
    protected Tool fTool;
    protected StatusLine fStatusLine;
    protected StandardDrawingView fView;
    protected ToolJButton fSelectedToolButton;
    protected static final String ERR_EXTERN_IMPORT_EXPORT = "error.imExport";
    protected static final String ERR_NO_SUITABLE_HARDWARE = "error.imExport.noSuitableHardware";
    public static final String IMAGES = "/DE/siemens/ad/logo/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    protected ToolSelectionAction fToolAction;

    private void readFromObjectInput(String file, ProgressListener progressListener) throws IOException {
        int major = 0;
        int minor = 0;
        FileInputStream stream = null;
        ObjectInput input = null;
        try {
            stream = new FileInputStream(file);
            input = new ObjectInputStream(stream);
            if (this.fDrawing != null) {
                this.fDrawing.release();
            }
            major = input.readInt();
            minor = input.readInt();
            Global.latestFileCreaterVersion = major;
            int zoomf = input.readInt();
            int counter = input.readInt();
            progressListener.setMinimum(0);
            progressListener.setMaximum(counter + 1);
            progressListener.setValue(0);
            for (int i = 0; i < counter; ++i) {
                progressListener.setValue(i);
                input.readObject();
            }
            this.fDrawing = (Drawing)input.readObject();
            progressListener.setValue(counter + 1);
            LogoDrawing logoDrawing = (LogoDrawing)this.fDrawing;
            logoDrawing.constructConstraint();
            ((LogoDrawingView)this.view()).getZoomManager().setZoom(zoomf);
            this.fView.setDrawing(this.fDrawing);
            WiringDiagram wd = logoDrawing.getWiringDiagram();
            if (logoDrawing.isUnknownV2()) {
                Hardware[] suitableHW = wd.getSuitableHardware(new ArrayList());
                if (suitableHW == null) {
                    throw new ClassNotFoundException("SuitableHardware");
                }
                try {
                    wd.setHardware(suitableHW[0]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    wd.setHardware(suitableHW[0]);
                }
            }
            logoDrawing.registerListeners();
        }
        catch (IOException e) {
            try {
                stream = new FileInputStream(file);
                input = new ObjectInputStream(stream);
                Object o = input.readObject();
                if (o.equals("prog.kop")) {
                    this.showStatus(Language.getString("msg.unknownFileType", "Unknown file content") + ": " + o);
                    throw new IOException(Language.getString("msg.unsupportedFileContent", "Unsupported filecontent: ") + ": " + o);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            System.err.println("File written with Softwareversion: " + major + "." + minor);
            e.printStackTrace();
            throw e;
        }
        catch (ClassNotFoundException e) {
            String s;
            if (e.getMessage().equals("SuitableHardware")) {
                s = Language.getString("log.msg.noSuitableHardware", "No suitable Hardware found");
            } else {
                s = "Class not found: " + e;
                this.showStatus(s);
                System.out.println(s);
            }
            throw new IOException(s);
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu menu = new CommandMenu("Align");
        menu.add(new ToggleGridCommand("Toggle Snap to Grid", this.fView, new Point(4, 4)));
        menu.addSeparator();
        menu.add(new AlignCommand("Lefts", this.fView, 0));
        menu.add(new AlignCommand("Centers", this.fView, 1));
        menu.add(new AlignCommand("Rights", this.fView, 2));
        menu.addSeparator();
        menu.add(new AlignCommand("Tops", this.fView, 3));
        menu.add(new AlignCommand("Middles", this.fView, 4));
        menu.add(new AlignCommand("Bottoms", this.fView, 5));
        return menu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu menu = new CommandMenu("Arrow");
        menu.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.fView));
        menu.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.fView));
        menu.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.fView));
        menu.add(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this.fView));
        return menu;
    }

    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", "FillColor"));
        menu.add(this.createColorMenu("Pen Color", "FrameColor"));
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", "TextColor"));
        return menu;
    }

    protected JMenu createColorMenu(String title, String attribute) {
        CommandMenu menu = new CommandMenu(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            menu.add(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this.fView));
        }
        return menu;
    }

    protected JComponent createContents(StandardDrawingView view) {
        return null;
    }

    protected JMenu createDebugMenu() {
        JMenu menu = new JMenu("Debug");
        JMenuItem mi = new JMenuItem("Simple Update");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Buffered Update");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
            }
        });
        menu.add(mi);
        return menu;
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        return new StandardDrawingView(this, d.width, d.height);
    }

    protected JMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            menu.add(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this.fView));
        }
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = new CommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < sizes.length; ++i) {
            menu.add(new ChangeAttributeCommand(Integer.toString(sizes[i]), "FontSize", new Integer(sizes[i]), this.fView));
        }
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu menu = new CommandMenu("Font Style");
        menu.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.fView));
        menu.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.fView));
        menu.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.fView));
        return menu;
    }

    protected Component createStandardToolBar() {
        return null;
    }

    protected ToolJButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolJButton(this, iconName, toolName, tool);
    }

    protected JToolBar createToolPalette() {
        HideableToolBar palette = new HideableToolBar();
        palette.setTitle(Language.getString("toolbar.title.tools", "Tools"));
        CSH.setHelpIDString((Component)palette, (String)"toolbar.drawing");
        return palette;
    }

    protected void createTools(JToolBar palette) {
    }

    protected Dimension defaultSize() {
        int height;
        int width;
        String widthStr = LogoProperties.instance().getProperty("app.width", "800");
        String heightStr = LogoProperties.instance().getProperty("app.height", "600");
        try {
            width = Integer.parseInt(widthStr);
        }
        catch (NumberFormatException nfe) {
            width = 800;
        }
        if (width <= 0) {
            width = 800;
        }
        try {
            height = Integer.parseInt(heightStr);
        }
        catch (NumberFormatException nfe) {
            height = 600;
        }
        if (height <= 0) {
            height = 600;
        }
        return new Dimension(width, height);
    }

    protected void destroy() {
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void exit() {
        this.destroy();
        System.exit(0);
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(400, 600);
    }

    public String getName() {
        return Application.getName();
    }

    public JToolBar getStandardToolBar() {
        return this.fStandardToolBar;
    }

    protected final String getTempfileName() {
        return "C:\\$TEMP$.$$$";
    }

    private String guessType(String file) {
        if (file.toLowerCase().endsWith(".draw")) {
            return "storable";
        }
        if (file.toLowerCase().endsWith("lsc") || file.toLowerCase().endsWith("lld") || file.toLowerCase().endsWith("lma") || file.toLowerCase().endsWith("udf")) {
            return "serialized";
        }
        return "unknown";
    }

    public void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    protected void loadDrawing(String file, ProgressListener progressListener) throws LogoIOException {
        String type = this.guessType(file);
        try {
            if (type.equals("storable")) {
                this.readFromStorableInput(file);
            } else if (type.equals("serialized")) {
                this.readFromObjectInput(file, progressListener);
            } else {
                return;
            }
            this.toolDone();
        }
        catch (IOException e) {
            Log.println(Language.getString("error.openFile", "Reading % failed", file));
            if (e.getMessage() != null) {
                Log.println(e.getMessage());
            } else {
                Log.println(e.toString());
            }
            if (!(e instanceof LogoIOException)) {
                throw new LogoIOException(e.getMessage());
            }
            throw (LogoIOException)e;
        }
    }

    protected void open() {
        ToolTipManager.sharedInstance().setEnabled(true);
        this.fToolPalette = this.createToolPalette();
    }

    public void print() {
    }

    private void readFromStorableInput(String file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            StorableInput input = new StorableInput(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error: " + e);
        }
    }

    protected void saveAsObjectOutput(File file, ProgressListener progressListener) throws IOException, FileNotFoundException {
        ObjectOutput output = null;
        try {
            Figure f;
            progressListener.setNote(Language.getString("msg.saveMessage", "Saving program..."));
            FileOutputStream stream = new FileOutputStream(file);
            output = new ObjectOutputStream(stream);
            FigureEnumeration enumeration = this.fDrawing.figures();
            int counter = 0;
            while (enumeration.hasMoreElements()) {
                f = enumeration.nextFigure();
                ++counter;
            }
            progressListener.setMinimum(0);
            progressListener.setMaximum(counter + 1);
            progressListener.setVisible(true);
            Version version = Version.getCurrentVersion();
            output.writeInt(version.getMajorVersion());
            output.writeInt(version.getMinorVersion());
            output.writeInt(((LogoDrawingView)this.view()).getZoomManager().getZoom());
            output.writeInt(counter);
            counter = 1;
            enumeration = this.fDrawing.figures();
            while (enumeration.hasMoreElements()) {
                progressListener.setValue(counter);
                f = enumeration.nextFigure();
                output.writeObject(f);
                ++counter;
            }
            output.writeObject(this.fDrawing);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void selectionChanged(DrawingView view) {
    }

    public void setDrawing(Drawing drawing) {
        this.fView.setDrawing(drawing);
        this.fDrawing = drawing;
    }

    public void setSelected(ToolJButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void setStatuslineVisible(boolean newValue) {
        this.fStatusLine.setVisible(newValue);
    }

    public void setTool(Tool t, String name, ToolSelectionAction toolSelectionAction) {
        if (this.fTool != t) {
            if (this.fTool != null) {
                this.fTool.deactivate(this.fView);
                this.fTool = null;
                this.fToolAction.setSelected(false);
            }
            this.fTool = t;
            this.fToolAction = toolSelectionAction;
            if (this.fTool != null && this.fStatusLine != null) {
                this.fToolAction.setSelected(true);
                this.fStatusLine.setText(name);
                this.fTool.activate(this.fView);
            }
        }
    }

    public void setZoomValue(int zoomValue) {
        String zoom = new Integer(zoomValue).toString();
        ((LogoComfortStatusLine)this.fStatusLine).setZoom(zoom);
    }

    public void showStatus(String string) {
        this.fStatusLine.setText(string);
    }

    public Tool tool() {
        return this.fTool;
    }

    public void toolDone() {
    }

    public void userSelectedButton(ToolJButton toolButton) {
        this.setSelected(toolButton);
    }

    public DrawingView view() {
        return this.fView;
    }
}

